import Optimizer
import random

# this optimizer generates random states and takes the best one
# has the option of a using a tabu list, this is VERY INNEFICIENT if most of the search space will be explored
class RandomOptimizer(Optimizer.Optimizer):
    # num_batches: how many batchs to iterate over
    # states_per_batch: how many states per batch
    # use_taby: boolean indicated whether previously explored states should be removed from pool of potential states
    def __init__(self, num_batches, states_per_batch, num_bits, number_top_states, characterizer,use_tabu = False, verbose=False):
        super(RandomOptimizer,self).__init__(number_top_states,characterizer,verbose)
        self.verbose = verbose

        self.num_batches = num_batches
        self.states_per_batch = states_per_batch

        self.num_bits = num_bits
        self.maximum_state =  2**num_bits-1

        self.batch_counter = 0
        self.current_states = []

        self.use_tabu = use_tabu

    def isFinished(self):
        if self.verbose:
            print "Checking if Finished"
        return self.batch_counter >= self.num_batches

    def getNextStates(self):
        if self.verbose:
            print "Getting Next States"
        self.current_states = []
        for i in range(self.states_per_batch):
            random_state = random.randint(0, self.maximum_state)
            if self.use_tabu:
                while random_state in self.explored_states.key():
                    random_state = random.randint(0, self.maximum_state)
            self.current_states += [random_state]
        self.batch_counter = self.batch_counter + 1
        return self.current_states
